<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Login controller will have authentication realted functions
 */
class Csv_upload extends CI_Controller {

    public function __construct() {
        parent::__construct();
       // use_ssl();
	   
	   $this->common->check_access_rights('Csv_upload'); 
	   $this->load->model('Dashboard_model');
    }

   
    public function index() {
		$data['role'] = $this->session->userdata('role');
        $this->template->load('template/private','csv-files-view', $data); 
    }
	
	
	public function get_csv_list() {
        $list_data = array('status' => 'error', 'data' => '');
        $post = $this->input->post(NULL,TRUE);
	
        $list = $this->Dashboard_model->get_csv_list('','','','','','csv_master.file_name');
        if (!empty($list)) {
			$index = 1;
            foreach ($list as $csv) {
				$actions = '<div class="btn-group">
                            <a href="'.$this->config->item('include_url').'/upload_files/'.$csv['file_name'].'" rel="50%" data-toggle="tooltip" data-placement="top" title="Download File" class="toolTips btn btn-default"><span class="fa fa-file-excel-o"></span></a>					
                            </div>';
							
                $data[] = array(
                    $index,
                    $csv['created_on'],                   
                    $actions                  
                );
				$index++;
            }
            $list_data = array('status' => 'done', 'data' => $data);
        }
        
        echo json_encode($list_data);
    }
	
	
	function read_excel() {
    	$field_name='csv_file';
		$csv_data = array();
    	$response=array('message'=>'<div class="alert alert-danger">There was an issue with your file please try again </div>','status'=>0);
    	if(!empty($_FILES) && !empty($_FILES[$field_name]["tmp_name"])){
    		if(!empty($_FILES[$field_name]['name']) && strpos($_FILES[$field_name]['name'], '.')){
    			$this->load->helper('file');
    			$file_parts=explode('.', $_FILES[$field_name]['name']);
    			$accepted_extensions=array('xls','xlsx','csv');
    			if(in_array($file_parts[1], $accepted_extensions)){
    				$file_name=time().'.'.$file_parts[1]; 
    				if(!empty($file_name)){
    					$upload_path='includes/upload_files';
			    		$config['upload_path'] =$upload_path; 
			            $config['allowed_types'] = '*';
			            $config['file_name'] = $file_name;
			            $this->load->library('upload', $config);
			            if ($this->upload->do_upload($field_name)) {
			            	require_once(FCPATH.'application/libraries/PHPExcel.php');
							$file_path=$upload_path.'/'.$file_name;
							$objPHPExcel = PHPExcel_IOFactory::load($file_path);
							$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
			            	
							$i = 1;
							foreach ($cell_collection as $cell) {
								$column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
								$row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
								if($cell == 'A'.$i) {
									$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getFormattedValue();
									$i++;
								}else {
									$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
								}
								
								if ($row > 1){								
									$arr_data[$row][$column] = $data_value;     
								} 	
								
							}
								
							$updated_date = date('Y-m-d H:i:s');
							foreach($arr_data as $line => $row_data) {
								if(!empty($row_data['A']) && !empty($row_data['I'])) {
									$user_exists = $this->Dashboard_model->chk_user_exists($row_data['I']);
									if($user_exists) {
										//$csv_date = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($row_data['A']));
										$csv_date = date('Y-m-d', strtotime($row_data['A']));
										
										if(strtotime($csv_date) > strtotime('2000-01-01')) {
											$csv_data []= array(
												'date' => $csv_date,    
												'brand_name' => isset($row_data['B']) ? trim($row_data['B']) : '',    
												'domain' => isset($row_data['C']) ? trim($row_data['C']) : '',    
												'device_type' => isset($row_data['D']) ? trim($row_data['D']) : '',        
												'requests' => isset($row_data['E']) ? trim($row_data['E']) : '',       
												'impressions' => isset($row_data['F']) ? trim($row_data['F']) : '',        
												'cpm' => isset($row_data['G']) ? trim($row_data['G']) : '',    
												'estimated_revenue' => isset($row_data['H']) ? trim($row_data['H']) : '', 
												'user_id' => isset($row_data['I']) ? trim($row_data['I']) : '', 
												'file_name' => $file_name,										
												'created_on' => $updated_date
											);	
										}else {
											$response['message']='<div class="alert alert-danger">Date format id not proper!</div>';
										}
									}else {
										$response['message']='<div class="alert alert-danger">User id '.$row_data['I'].' is not present in the system!</div>';
									}									
								}
							}
							
							$database_status=0;        					 
        					 if(!empty($csv_data)){
								foreach($csv_data as $data) {
								$data_exist = $this->Dashboard_model->chk_data_exist($data);
								if($data_exist) {
									$database_status+=$this->Dashboard_model->update_csv($data);
								}else {
									$database_status+=$this->Dashboard_model->insert_csv($data);
								}
								}
								
								if(!empty($database_status)){
									//@unlink($file_path);
									$response['status']=1;
									$response['message']='<div class="alert alert-success">Data Import Successfully</div>';
								}
								else{
									$response['status']=1;
									$response['message']='<div class="alert alert-warning">No Records Added/Updated, we assume everything  is up to date</div>';
								}
        					 }

														
			            }
			            else{
			            	$response['message']='<div class="alert alert-danger">An Error Occured while uploading the file</div>';
			            }
    				}
    			}
    			else{
    				$response['message']='<div class="alert alert-danger">The file you have uploaded has not a valid extension acceptable to our system</div>';
    			}
    		}
    		else{
    			$response['message']='<div class="alert alert-danger">No File has been Uploaded</div>';
    		}    		
    	}
    	else{
    		$response['message']='<div class="alert alert-danger">No File has been Uploaded</div>';
    	}
    	echo $response['message'];
	}
	
	
	public function delete_csv() {

        $post = $this->input->post(NULL, TRUE);
      
        $add_response = array(
            'is_added' => FALSE
        );
        $responce = array('status' => 'error','message' => ''); 

		$start_date = isset($post['start_date']) && $post['start_date'] != '' ? date('Y-m-d', strtotime($post['start_date'])) : '';
		$end_date = isset($post['end_date']) && $post['end_date'] != '' ? date('Y-m-d', strtotime($post['end_date'])) : '';
		$domain = isset($post['domain']) && $post['domain'] != '' ? $post['domain'] : '';
		$device = isset($post['device']) && $post['device'] != '' ? $post['device'] : '';
		$user = isset($post['user']) && $post['user'] != '' ? $post['user'] : '';
				
		$add_response = $this->Dashboard_model->delete_csv($domain, $device, $user, $start_date, $end_date);
		           
        if ($add_response) {
            $responce = array('status' => 'done','message' => '<div class="alert alert-success">Records deleted successfully.</div>');			
            echo json_encode($responce);
        } else {
            $responce = array('status' => 'error','message' => '<div class="alert alert-danger">An error has occurred while deleting Records!</div>');
			echo json_encode($responce);
        }
    }
	
	

}
