<?php

if (!defined('BASEPATH'))
   exit('No direct script access allowed');

class Common {

   public $data = array();

   public function __construct() {
      $this->CI = & get_instance();
      $this->role_utilities = array();
   }

   /**
    * Objective is to create dfp ad unit
    * @param string $adunit_name ad unit name
    * @param int $width width
    * @param int $height 
    * @return array having status and dfp unit id
    */
   public function create_dfp_ad_unit($adunit_name, $width, $height) {
      $base_path = $this->CI->config->item('base_path');
      $path = $base_path . '/application/third_party/dfp_lib';
      set_include_path(get_include_path() . PATH_SEPARATOR . $path);
      require_once $path . '/Google/Api/Ads/Dfp/Lib/DfpUser.php';
      require_once $path . '/ExampleUtils.php';
      try {
         // Get DfpUser from credentials in "../auth.ini"
         // relative to the DfpUser.php file's directory.
         $user = new DfpUser();

         // Log SOAP XML request and response.
         $user->LogDefaults();

         // Get the InventoryService.
         $inventoryService = $user->GetService('InventoryService', 'v201511');

         // Get the NetworkService.
         $networkService = $user->GetService('NetworkService', 'v201511');

         // Get the effective root ad unit's ID for all ad units to be created under.
         $network = $networkService->getCurrentNetwork();
         $effectiveRootAdUnitId = $network->effectiveRootAdUnitId;

         $adUnits = array();

         $adUnit = new AdUnit();
         $adUnit->name = $adunit_name;
         $adUnit->parentId = $effectiveRootAdUnitId;
         $adUnit->description = '';
         $adUnit->targetWindow = 'BLANK';

         // Create ad unit size.
         $adUnitSize = new AdUnitSize();
         $adUnitSize->size = new Size($width, $height, false);
         $adUnitSize->environmentType = 'BROWSER';

         // Set the size of possible creatives that can match this ad unit.
         $adUnit->adUnitSizes = array($adUnitSize);

         $adUnits[] = $adUnit;


         // Create the ad units on the server.
         $adUnits = $inventoryService->createAdUnits($adUnits);

         // Display results.
         if (isset($adUnits)) {
            foreach ($adUnits as $adUnit) {
               $response = array('is_created' => TRUE, 'ad_unit_id' => $adUnit->id);
            }
         } else {
            $response = array('is_created' => FALSE, 'ad_unit_id' => '0');
         }
      } catch (OAuth2Exception $e) {
         $response = array('is_created' => FALSE, 'ad_unit_id' => '0');
      } catch (ValidationException $e) {
         $response = array('is_created' => FALSE, 'ad_unit_id' => '0');
      } catch (Exception $e) {
         $response = array('is_created' => FALSE, 'ad_unit_id' => '0');
      }
      return $response;
   }

   /**
    * Objective is to create excel file
    * @param array $data_array having data
    * @param $file_name having name with location
    * @return true on sucess
    */
   public function create_excel_file($file_info, $data_array, $file_name, $multiple_sheet = FALSE) {
      $base_path = $this->CI->config->item('base_path');
      $include_path = $this->CI->config->item('include_path');
      require_once($base_path . "/application/third_party/PHPExcel.php");
      //$this->CI->load->library('PHPExcel');
      $objPHPExcel = new PHPExcel();
      // Set properties
      $objPHPExcel->getProperties()->setCreator("ABM.Media")
         ->setLastModifiedBy("ABM.Media")
         ->setTitle("Subscriptions")
         ->setKeywords("office 2007 openxml php");
      $styleArray = array('font' => array('bold' => true));
      $sheet_index = 0;
      $sheet = $objPHPExcel->getActiveSheet();
      if (count($file_info) > 0) {
         $rowNumber = 1;
         foreach ($file_info as $key => $val) {
            $col = 'A';
            if ($key == 'Logo Image') {
               $gdImage = imagecreatefromjpeg($include_path . '/images/' . $val);
               // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
               $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
               $objDrawing->setName('ABM LOGO');
               $objDrawing->setDescription('ABM LOGO');
               $objDrawing->setImageResource($gdImage);
               $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_JPEG);
               $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
               $objDrawing->setHeight(70);
               $objDrawing->setCoordinates($col . $rowNumber);
               $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
               $rowNumber = $rowNumber + 5;
            } else {
               $sheet->getStyle($col . $rowNumber)->applyFromArray($styleArray);
               $sheet->setCellValue($col . $rowNumber, $key);
               $col++;
               $sheet->setCellValue($col . $rowNumber, $val);
               $rowNumber = $rowNumber + 1;
            }
         }
         $sheet_index = $sheet_index + 1;
         $objPHPExcel->getActiveSheet()->setTitle('ABM Subscription');
      }
      if (!$multiple_sheet) {
         $objWorkSheet = $objPHPExcel->createSheet();
         $objPHPExcel->setActiveSheetIndex($sheet_index);
         $sheet = $objPHPExcel->getActiveSheet();
         $rowNumber = 1;
         //$this->display_data($data_array);         
         foreach ($data_array as $key => $row) {
            //$this->display_data($row);
            $col = 'A';
            foreach ($row as $cell) {
               if ($key == "0") {
                  $sheet->getStyle($col . $rowNumber)->applyFromArray($styleArray);
               }
               $sheet->setCellValue($col . $rowNumber, $cell);
               $col++;
            }
            $rowNumber = $rowNumber + 1;
         }
      } else {
         //$this->display_data($data_array);
         //$sheet_index = 0;
         foreach ($data_array as $sheet_number => $data) {
            //echo "<br/>row number (" . $sheet_index . ")";
            if ($sheet_index > 0) {
               $objWorkSheet = $objPHPExcel->createSheet();
            }
            $objPHPExcel->setActiveSheetIndex($sheet_index);
            $sheet = $objPHPExcel->getActiveSheet();
            $rowNumber = 1;
            //$this->display_data($data);
            foreach ($data as $key => $row) {
               $col = 'A';
               foreach ($row as $cell) {
                  if ($key == "0") {
                     $sheet->getStyle($col . $rowNumber)->applyFromArray($styleArray);
                  }
                  $sheet->setCellValue($col . $rowNumber, $cell);
                  $col++;
               }
               $rowNumber++;
            }
            $sheet_index = $sheet_index + 1;
            $objPHPExcel->getActiveSheet()->setTitle('Worksheet ' . $sheet_index);
         }
      }
      $objPHPExcel->setActiveSheetIndex(0);
      $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
      $path = $base_path . "/$file_name";
      $objWriter->save($path);
   }

   /**
    * Objective is to pdf file
    * @param string $file_path pdf file path with name
    * @param array $pdf_pages pdf pages having html of each page
    * @return boolean true on success
    */
   public function create_pdf($file_path, $pdf_pages) {
      $base_path = $this->CI->config->item('base_path');
      require_once($base_path . "/application/third_party/tcpdf/config/tcpdf_config.php");
      require_once($base_path . "/application/third_party/tcpdf/tcpdf.php");
      require_once($base_path . "/application/third_party/tcpdf/mypdf.php");
      $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
      $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
      $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
      $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
      $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
// set margins
      $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
      $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
      $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
      $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
      $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
      if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
         require_once(dirname(__FILE__) . '/lang/eng.php');
         $pdf->setLanguageArray($l);
      }

// set default font subsetting mode
      $pdf->setFontSubsetting(true);

// Set font
// dejavusans is a UTF-8 Unicode font, if you only need to
// print standard ASCII chars, you can use core fonts like
// helvetica or times to reduce file size.
      $pdf->SetFont('helvetica', '', 10, '', true);

      foreach ($pdf_pages as $page_html) {
         $pdf->AddPage();
         $pdf->writeHTMLCell(0, 0, '', '', $page_html, 0, 1, 0, true, '', true);
      }
      $pdf->Output($file_path, 'F');
      return TRUE;
   }

   /**
    * Objective is to check access rights for user
    * @param string $utility name
    */
   public function check_access_rights($module_name) {
   
      $this->validate_session();
      
      $role_id = $this->CI->session->userdata('role');
           
      if($role_id == 1) {
      	$access_modules = array('Dashboard', 'Csv_upload', 'Users');
      }else if($role_id == 2) {
      	$access_modules = array('Dashboard', 'Profile');
      }
	  
	  if(in_array($module_name, $access_modules)) {
		return true;
	  }else {
		redirect(base_url());
	  }
    
   }

   /**
    * Objective is to display array in pre tag
    * @param array $data
    * @return string array in pre tag
    */
   public function display_data($data) {
      echo '<pre>';
      print_r($data);
      echo '</pre>';
   }

   /**
    * Objective is to return module list for logged in user
    * @param int $role_id role id of logged in user
    * @return array having role list
    */
   public function get_access_module_list($role_id) {
      $admin_roles = array('Dashboard', 'profile');

      $module_list = array();
      switch ($role_id) {
         case '1' : $module_list = $admin_roles;
            break;
         case '2' : $module_list = $account_roles;
            break;
      }
      return $module_list;
   }

   /**
    * Objective is to get menu for user
    * @param int $role role id
    * @param int $user_id user id
    * @return array having menu list
    */
   public function get_menu_for_user($role, $user_id) {
      $menu = $this->CI->Menu_model->get_menu_and_utilities_for_user($role, $user_id);
      return $menu;
   }

   /**
    * Objective is to convert number in human readable number
    * @param int $number
    * @return string number string
    */
   public function nice_number($number) {
      // first strip any formatting;
      $number = (0 + str_replace(",", "", $number));

      // is this a number?
      if (!is_numeric($number))
         return false;

      // now filter it;
      if ($number > 1000000000000)
         return round(($number / 1000000000000), 1) . ' trillion';
      else if ($number > 1000000000)
         return round(($number / 1000000000), 1) . ' billion';
      else if ($number > 1000000)
         return round(($number / 1000000), 1) . ' million';
      else if ($number > 1000)
         return round(($number / 1000), 1) . ' thousand';

      return number_format($number);
   }

   /**
    * To sort multi level array
    * @param array $unsorted_array unsorted array
    * @param string @subkey key value
    * @return array $c sorted array
    */
   public function subval_sort($unsorted_array, $subkey) {
      $sorted_array = array();
      $temp_array = array();
      foreach ($unsorted_array as $k => $v) {
         $temp_array[$k] = strtolower($v[$subkey]);
      }
      if (is_array($temp_array)) {
         asort($temp_array);
         foreach ($temp_array as $key => $val) {
            $sorted_array[$key] = $unsorted_array[$key];
         }
      }
      return $sorted_array;
   }

   /**
    * Objective is to send curl request for similar web
    * @param string $url having url
    * @return array api response
    */
   public function send_curl_request_similarweb($url) {
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_HEADER, 0);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      if ($_SERVER["HTTP_HOST"] == "localhost") {
         curl_setopt($ch, CURLOPT_PROXY, '172.16.4.1:3128');
      }
      $content = curl_exec($ch);
      $info = curl_getinfo($ch);
      curl_close($ch);
      $curl_response = json_decode($content);
      return $curl_response;
   }

   /**
    * Objective is to send CURL Request
    * @param string $url url
    * @param array $param any parameter you want to pass in request
    * @return array response of curl
    */
   public function send_curl_request($url, $param = '', $token = '', $file_name = '', $request = 'POST') {
      $data_string = '';
      if (is_array($param)) {
         $data_string = json_encode($param);
      }
      //echo $data_string;
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url);
      if ($data_string != '') {
         curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $request);
         curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
         if ($token != '') {
            //echo 'herer<br/>';
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
               'Content-Type: application/json',
               "Authorization: $token",
               'Content-Length: ' . strlen($data_string)));
         } else {
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
               'Content-Type: application/json',
               'Content-Length: ' . strlen($data_string))
            );
         }
      } else {
         if ($token != '') {
            if ($request != 'POST') {
               curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $request);
            }
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: $token"));
         } else {
            curl_setopt($ch, CURLOPT_HEADER, 0);
         }
      }
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      if ($_SERVER["HTTP_HOST"] == "localhost") {
         curl_setopt($ch, CURLOPT_PROXY, '172.16.4.1:3128');
      }
      if ($file_name != '') {
         $base_path = $this->CI->config->item('base_path');
         $file = fopen($base_path . "/downloads/appnexus/$file_name", 'w');
         $this->display_data($file);
         //echo "file path is $base_path/downloads/appnexus";
         curl_setopt($ch, CURLOPT_FILE, $file);
      }
      $content = curl_exec($ch);
      $info = curl_getinfo($ch);
      curl_close($ch);
      $curl_response = json_decode($content);
      //$this->display_data($info);
      //echo "response<br/>";
      // $this->display_data($curl_response);
      if (isset($curl_response->response)) {
         return $curl_response->response;
      } else {
         return $curl_response;
      }
   }

   /**
    * Objective is call url and get password
    * @return string having password
    */
   public function send_curl_request_for_password() {
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, 'http://www.dinopass.com/password/strong');
      curl_setopt($ch, CURLOPT_HEADER, 0);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      if ($_SERVER["HTTP_HOST"] == "localhost") {
         curl_setopt($ch, CURLOPT_PROXY, '172.16.4.1:3128');
      }
      $content = curl_exec($ch);
      $info = curl_getinfo($ch);
      curl_close($ch);
      $password = '';
      if ($info['http_code'] == 200) {
         $password = $content;
      }
      return $password;
   }

   /**
    * Objective is to send mail 
    * @param string $to email address to whom mail to be send
    * @param string $subject subject of email
    * @param string $mail_content mail conent
    * @param array $cc_address cc address
    * @param array $bcc_address bcc address    
    * @return boolean true on success
    */
   public function send_mail($to, $subject, $mail_content, $cc_address = '', $bcc_address = '') { 
      $base_path = $this->CI->config->item('base_path');
      require_once($base_path . '/application/third_party/php_mailer/PHPMailerAutoload.php');
      $mail = new PHPMailer();
      $mail->isSMTP();
      $mail->SMTPDebug = 0;
      $mail->Host = "smtp.gmail.com";
      $mail->Port = 465;
      $mail->SMTPAuth = true;
      $mail->SMTPSecure = "ssl";
      $mail->Username = "snehal@eninteractive.com";
      $mail->Password = "breen2015";
      $mail->setFrom('snehal@eninteractive.com', 'Snehal Eninteractive');
      $mail->isHTML(true); 
      
      if (is_array($to) && count($to) > 0) {
         foreach ($to as $to_add)
            $mail->addAddress($to_add, '');
      }else {
		$mail->addAddress($to, '');
	  }

      if (is_array($cc_address) && count($cc_address) > 0) {
         foreach ($cc_address as $cc_add)
            $mail->addCC($cc_add, '');
      }
      if (is_array($bcc_address) && count($bcc_address) > 0) {
         foreach ($bcc_address as $bcc_add)
            $mail->addBCC($bcc_add, '');
      }

      $mail->Subject = $subject;
      $mail->msgHTML($mail_content);
      //if ($_SERVER["HTTP_HOST"] != "localhost") {
         if (!$mail->send()) { 
            return false;
         } else {
            return true;
         }
      //} else
         //return true;
   }
   
   
   /**
    * Objective is to validate session for ajax call
    * @param null
    * @return will open modal and ask to enter username and password
    */
   public function validate_session() {
      $base_url = $this->CI->config->item('base_url');
      if ($this->CI->session->userdata('user_id') == '') {
         redirect($base_url . '/login/logout');
      }
      return;
   }

   /**
    * Objective is to validate session for ajax call
    * @param null
    * @return will open modal and ask to enter username and password
    */
   public function validate_session_json() {
      $CI = & get_instance();
      if ($CI->session->userdata('user_id') == '') {
         $response = array('status' => 'session_expired');
         echo json_encode($response);
         exit;
      } else
         return TRUE;
   }
   
   
  
}
