<?php

Class Dashboard_model extends CI_Model {

   function __construct() {
      // Call the Model constructor
      parent::__construct();
   }

   /**
    * Objective is to add user
    * @param array $user_data having user related details
    * @return array having status and user_id
    */
   function insert_csv($data) {
         return $this->db->insert('csv_master', $data);
   }

  
   /**
    * Objective is to get user list 
    * @param string $user_id id of user
    * @param string $role_id if wnats list of particular roles
    * @param string $username username
    * @return array list of users
    */
   function get_csv_list($user_id='', $device='', $domain='', $start_date='', $end_date='', $group_by='') {
	  
      $list = array();
	  
	  if(!empty($group_by)) {
		$select = " csv_master.id, csv_master.date, csv_master.brand_name, csv_master.domain, csv_master.device_type, sum(csv_master.requests) as requests, sum(csv_master.impressions) as impressions, concat('$ ', sum(trim(replace(csv_master.cpm, '$', '')) + 0.0)) as cpm, sum(csv_master.estimated_revenue) as estimated_revenue, csv_master.user_id, csv_master.file_name, csv_master.created_on, ";
	  }else {
		$select = " csv_master.id, csv_master.date, csv_master.brand_name, csv_master.domain, csv_master.device_type, csv_master.requests, csv_master.impressions, csv_master.cpm, csv_master.estimated_revenue, csv_master.user_id, csv_master.file_name, csv_master.created_on, ";
	  }
      $sql = "select $select user_master.first_name from csv_master left join user_master on user_master.id = csv_master.user_id where 1=1 ";
	  if(!empty($user_id) && $user_id != '') {
		if(is_array($user_id)) {
			$user_list = implode("','",$user_id);
			if($user_list != '') {
				$sql .= " and csv_master.user_id in('$user_list')";
			}
		}else {
			$sql .= " and csv_master.user_id = '$user_id'";
		}
	  }
	  if(!empty($device) && $device != '') {
		$device_list = implode("','",$device);
		if($device_list != '') {
			$sql .= " and csv_master.device_type in('$device_list')";
		}
	  }
	  if(!empty($domain) && $domain != '') {
		$domain_list = implode("','",$domain);
		if($domain_list != '') {
			$sql .= " and csv_master.domain in('$domain_list')";
		}
	  }
	  if(!empty($start_date) && !empty($end_date)) {
		$sql .= " and date(csv_master.date) between '$start_date' and '$end_date'";
	  }
	  
	  if(!empty($group_by)) {
		$sql .= " group by $group_by";
	  }
      
      $query = $this->db->query($sql);
      if ($query->num_rows() > 0) {
        $list = $query->result_array();
      }
      return $list;
   }

  
   function chk_data_exist($data) {
	  $sql = "select * from csv_master where date='".$data['date']."' and brand_name='".$data['brand_name']."' and domain='".$data['domain']."' and device_type='".$data['device_type']."'";
	
   	  $query = $this->db->query($sql);
      if ($query->num_rows() > 0) {
        return true;
      }else {
		return false;
	  }
   }
   
   
   function update_csv($data) {
		$this->db->where('date', $data['date']);
		$this->db->where('brand_name', $data['brand_name']);
		$this->db->where('domain', $data['domain']);
		$this->db->where('device_type', $data['device_type']);		
       return $this->db->update('csv_master', $data);
   }
   
   
   function chk_user_exists($user_id) {
	  $sql = "select * from user_master where id = '$user_id'";
	
   	  $query = $this->db->query($sql);
      if ($query->num_rows() > 0) {
        return true;
      }else {
		return false;
	  }
   }
   
   
   function delete_csv($domain='', $device='', $user_id='', $start_date='', $end_date='') {
	  $sql = 'delete from csv_master where 1=1';
	  if(!empty($user_id)) {
		if(is_array($user_id)) {
			$user_list = implode("','",$user_id);
			$sql .= " and user_id in('$user_list')";
		}else {
			$sql .= " and user_id = '$user_id'";
		}
	  }
	  if(!empty($device)) {
		$device_list = implode("','",$device);
		$sql .= " and device_type in('$device_list')";
	  }
	  if(!empty($domain)) {
		$domain_list = implode("','",$domain);
		$sql .= " and domain in('$domain_list')";
	  }
	  if(!empty($start_date) && !empty($end_date)) {
		$sql .= " and date(date) between '$start_date' and '$end_date'";
	  }
	  
	  return $this->db->query($sql);
   }
	  

}
